package MavenVaadinTest;

import com.vaadin.server.AbstractExtension;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.util.ReflectTools;

import java.io.Serializable;
import java.lang.reflect.Method;

public class WindowExportExtension extends AbstractExtension {

    private WindowListener listener;

    private WindowExportServerRpc serverRpc = new WindowExportServerRpc() {
        @Override
        public void onClick() {
            fireEvent(new WindowEvent(target));
        }
    };

    private Window target;

    WindowExportExtension(Window target, WindowListener listenerParam) {
        registerRpc(serverRpc);
        this.target = target;
        extend(target);
        this.listener = listenerParam;
        addButtonListener(listenerParam);
    }

    /**
     * Extends the target window with a button and a listener.
     *
     * @param target sf@param listener
     */
    public static void extend(Window target, WindowListener listener) {
        new WindowExportExtension(target, listener);
    }


    public interface WindowListener extends Serializable {

        public static final Method LINK_CLICK_METHOD = ReflectTools.findMethod(WindowListener.class, "click", WindowEvent.class);


        public void click(WindowEvent event);

    }

    private void addButtonListener(WindowListener listener) {
        addListener(WindowEvent.class, listener, WindowListener.LINK_CLICK_METHOD);
    }

    @Override
    public void detach() {
        super.detach();
        this.removeButtonListener(listener);
    }

    private void removeButtonListener(WindowListener listener) {
        removeListener(WindowEvent.class, listener, WindowListener.LINK_CLICK_METHOD);
    }

    public class WindowEvent extends Component.Event {

        public WindowEvent(Component source) {
            super(source);
        }
    }
}
