package MavenVaadinTest;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.Button;
import com.vaadin.client.ComponentConnector;
import com.vaadin.client.ServerConnector;
import com.vaadin.client.communication.RpcProxy;
import com.vaadin.client.extensions.AbstractExtensionConnector;
import com.vaadin.client.ui.VWindow;
import com.vaadin.shared.ui.Connect;


@Connect(WindowExportExtension.class)
public class WindowExportConnector extends AbstractExtensionConnector implements AttachEvent.Handler {

    private static final long serialVersionUID = 7979510101533888989L;
    private WindowExportServerRpc serverRpc = RpcProxy.create(WindowExportServerRpc.class, this);


    private transient VWindow window;
    private transient Element exportButtonElement;

    @Override
    protected void extend(ServerConnector target) {

        window = (VWindow) ((ComponentConnector) target).getWidget();
        exportButtonElement = DOM.createButton();
        exportButtonElement.setAttribute("type", "button");
        exportButtonElement.addClassName("btn");
        exportButtonElement.addClassName("export-button");

        window.addAttachHandler(this);

        Button wrap = Button.wrap(exportButtonElement);
        wrap.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                serverRpc.onClick();
            }
        });

        Event.sinkEvents(exportButtonElement, Event.ONMOUSEDOWN | Event.ONCLICK);
        Event.setEventListener(exportButtonElement, new EventListener() {
            @Override
            public void onBrowserEvent(Event event) {
                if (event.getTypeInt() == Event.ONMOUSEDOWN) {
                    event.stopPropagation();
                } else if (event.getTypeInt() == Event.ONCLICK) {
                    serverRpc.onClick();
                }
            }
        });
    }


    @Override
    public void onAttachOrDetach(AttachEvent event) {
        if (event.isAttached()) {
            Element closebox = window.getElement().getFirstChildElement().getFirstChildElement().getFirstChildElement().getNextSiblingElement();
            //VConsole.log("closebox  " + closebox);
            window.getElement().getFirstChildElement().getFirstChildElement().insertBefore(exportButtonElement, closebox);
        } else {
            Element parentElement = exportButtonElement.getParentElement();
            if (parentElement != null) {
                parentElement.removeChild(exportButtonElement);
            }
        }
    }


}
