package MavenVaadinTest;

import javax.servlet.annotation.WebServlet;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.*;
import com.vaadin.ui.Button.ClickEvent;

@Theme("mytheme")
@SuppressWarnings("serial")
public class MyVaadinUI extends UI
{

    @WebServlet(value = "/*", asyncSupported = true)
    @VaadinServletConfiguration(productionMode = false, ui = MyVaadinUI.class, widgetset = "MavenVaadinTest.AppWidgetSet")
    public static class Servlet extends VaadinServlet {
    }

    @Override
    protected void init(VaadinRequest request) {
        final VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        layout.setSpacing(true);
        setContent(layout);

        Resource doc = new ExternalResource("/VAADIN/themes/mytheme/mytheme.scss");

        MobileDocumentDownloadButton downloadButton = new MobileDocumentDownloadButton(doc);
        downloadButton.setCaption("Download document");

        layout.addComponent(downloadButton);

        Button openOverlayB = new Button("Open overlay");
        openOverlayB.addClickListener(new Button.ClickListener() {
            @Override
            public void buttonClick(ClickEvent event) {
                displayOverlay();
            }
        });

        layout.addComponent(openOverlayB);

    }

    private void displayOverlay(){
        Window overlay = new Window();
        overlay.setCaption("Test overlay");
        overlay.setWidth("400px");
        overlay.setHeight("300px");
        UI.getCurrent().addWindow(overlay);
    }

}
