package com.vaadinsample;

import javax.servlet.annotation.WebServlet;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.shared.ui.MultiSelectMode;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.Arrays;

@Theme("reindeer")
@SuppressWarnings("serial")
public class MyVaadinUI extends UI {

    @WebServlet(value = "/*", asyncSupported = true)
    
    @VaadinServletConfiguration(productionMode = false, ui = MyVaadinUI.class, widgetset = "com.vaadinsample.AppWidgetSet")
    public static class Servlet extends VaadinServlet {
    }
    

    @Override
    protected void init(VaadinRequest request) {
        final VerticalLayout layout = new VerticalLayout();
        setContent(layout);
        
        Table t = new Table("Persons",new BeanItemContainer(Person.class,Arrays.asList(
                new Person("John", "Doe"),
                new Person("Frank","Schmitt"),
                new Person("Other","Person"),
                new Person("Erika","Mustermann"),
                new Person("Max","Mustermann"))));
        t.setWidth("75%");
        layout.addComponent(t);
        t.setSelectable(true);
        t.setMultiSelect(true); 
        t.setMultiSelectMode(MultiSelectMode.DEFAULT);
    }

}
